﻿Public Class CustomerCollection
    Inherits CollectionBase

    'Składowa prywatna.
    Private objEmailHashtable As New Hashtable

    ' Właściwość EmailHashtable zwracająca składową objEmailHashtable.
    Public ReadOnly Property EmailHashtable() As Hashtable
        Get
            Return objEmailHashtable
        End Get
    End Property

    ' Właściwość Item przeznaczona do odczytu i aktualizacji elementu
    ' listy o określonym indeksie.
    Default Public Property Item(ByVal index As Integer) As Customer
        Get
            Return CType(Me.List.Item(index), Customer)
        End Get
        Set(ByVal value As Customer)
            Me.List.Item(index) = value
        End Set
    End Property

    ' Dodawanie klienta do kolekcji.
    Public Sub Add(ByVal newCustomer As Customer)
        Me.List.Add(newCustomer)

        ' Dodawanie adresu e-mail do kolekcji Hashtable.
        EmailHashtable.Add(newCustomer.Email.ToLower, newCustomer)
    End Sub


    ' Usuwanie klienta z kolekcji.
    Public Sub Remove(ByVal oldCustomer As Customer)
        Me.List.Remove(oldCustomer)

        ' Usuwanie klienta z kolekcji Hashtable.
        EmailHashtable.Remove(oldCustomer.Email.ToLower)
    End Sub


    ' Nowa implementacja metody RemoveAt.
    Public Shadows Sub RemoveAt(ByVal index As Integer)
        Remove(Item(index))
    End Sub

    ' Przeciążona wersja właściwości Item, pozwalająca wyszukać 
    ' klienta na podstawie adresu e-mail.
    Default Public ReadOnly Property Item(ByVal email As String) As Customer
        Get
            Return CType(EmailHashtable.Item(email.ToLower), Customer)
        End Get
    End Property


    ' Nowa implementacja metody Clear.
    Public Shadows Sub Clear()
        ' Czyszczenie kolekcji CollectionBase.
        MyBase.Clear()
        ' Czyszczenie kolekcji Hashtable.
        EmailHashtable.Clear()
    End Sub

End Class
